$(function() {
	var fqdn = "self-in.com";
	var selFinHeight = 240;
	var selFinWidth = 910;
	var url = window.location.href;
	var bukkenUrl = "";
	var detailUrl = "";
	var labelOffset = 0;

	if (url.match(/^(https?:\/\/suumo\.jp\/ms\/chuko\/[a-z_]+\/[a-z_\-]+\/nc_\d+\/?)/)) {
		bukkenUrl = RegExp.$1;
	}

	if (url.match(/bs=011/)) {
		if (url.match(/^(https?:\/\/suumo\.jp\/jj\/bukken\/shosai\/JJ[a-zA-Z0-9]+\/\?.*)/)) {
			bukkenUrl = RegExp.$1;
		}
	}

	if (bukkenUrl != "") {
		var bukkenResponse = $.ajax({
			type: "GET",
			url: bukkenUrl,
			dataType: "text"
		});

		bukkenResponse.done(function(bukkenData) {
			if (bukkenData.match(/<li><a href="(https?:\/\/suumo\.jp(\/[^"]+))"[^>]*>物件概要<\/a><\/li>/)) {
				detailUrl = "https://suumo.jp" + RegExp.$2;
			}

			if (detailUrl != "") {
				var detailResponse = $.ajax({
					type: "GET",
					url: detailUrl,
					dataType: "text"
				});

				detailResponse.done(function(detailData) {
					var postUrl = "https://" + fqdn + "/member/auto/json";

					var response = $.ajax({
						type: "POST",
						url: postUrl,
						dataType: "json",
						data: {
							"body": bukkenData,
							"body2": detailData
						}
					});

					response.done(function(data) {
						if (data.no_member) {
							alert('no_member');
						}
						else {
							changeSelFinStatus(selFinHeight, 1);

							var selFinOuterDiv = document.createElement("div");
							selFinOuterDiv.style.position = "fixed";
							selFinOuterDiv.style.left = "0px";
							selFinOuterDiv.style.top = "0px";
							selFinOuterDiv.style.width = "100%";
							selFinOuterDiv.style.height = String(selFinHeight) + "px";
							selFinOuterDiv.style.zIndex = "10000";
							selFinOuterDiv.style.backgroundColor = "rgba(0, 0, 0, 0.7)";
							selFinOuterDiv.style.color = "#ffffff";

							var selFinDiv = document.createElement("div");
							selFinDiv.style.position = "relative";
							selFinDiv.style.margin = "0px auto";
							selFinDiv.style.width = String(selFinWidth) + "px";
							selFinDiv.style.height = String(selFinHeight) + "px";
							selFinOuterDiv.appendChild(selFinDiv);

							var priceDiv = document.createElement("div");
							priceDiv.style.position = "absolute";
							priceDiv.style.top = "0px";
							priceDiv.style.left = "0px";
							priceDiv.style.padding = "0px 10px";
							priceDiv.style.width = String(selFinWidth - 20) + "px";
							priceDiv.style.height = "19px";
							priceDiv.style.lineHeight = "19px";
							priceDiv.style.fontWeight = "bold";
							priceDiv.style.fontSize = "16px";
							priceDiv.style.borderBottom = "1px solid #ffffff";
							priceDiv.innerHTML = "想定価格：" + String(data.min_expected_price) + "万円 ～ " + String(data.max_expected_price) + "万円";
							selFinDiv.appendChild(priceDiv);

							var labelDiv1 = makeLabelDiv(170, "0");
							selFinDiv.appendChild(labelDiv1);

							var labelDiv2 = makeLabelDiv(350, "25");
							selFinDiv.appendChild(labelDiv2);

							var labelDiv3 = makeLabelDiv(530, "50");
							selFinDiv.appendChild(labelDiv3);

							var labelDiv4 = makeLabelDiv(710, "75");
							selFinDiv.appendChild(labelDiv4);

							var labelDiv5 = makeLabelDiv(890, "100");
							selFinDiv.appendChild(labelDiv5);

							var titleLabelDiv1 = makeTitleLabelDiv(41, "価格の妥当性");
							selFinDiv.appendChild(titleLabelDiv1);

							var titleLabelDiv2 = makeTitleLabelDiv(71, "流動性");
							selFinDiv.appendChild(titleLabelDiv2);

							var titleLabelDiv3 = makeTitleLabelDiv(101, "耐震性");
							selFinDiv.appendChild(titleLabelDiv3);

							var titleLabelDiv4 = makeTitleLabelDiv(131, "住宅ローン減税");
							selFinDiv.appendChild(titleLabelDiv4);

							var titleLabelDiv5 = makeTitleLabelDiv(161, "管理状況");
							selFinDiv.appendChild(titleLabelDiv5);

							var scoreDiv1 = makeScoreDiv(40, data.price_score);
							selFinDiv.appendChild(scoreDiv1);

							var scoreDiv2 = makeScoreDiv(70, data.liquidity_score);
							selFinDiv.appendChild(scoreDiv2);

							var scoreDiv3 = makeScoreDiv(100, data.earthquake_score);
							selFinDiv.appendChild(scoreDiv3);

							var scoreDiv4 = makeScoreDiv(130, data.deduction_score);
							selFinDiv.appendChild(scoreDiv4);

							var scoreDiv5 = makeScoreDiv(160, data.management_score);
							selFinDiv.appendChild(scoreDiv5);

							var priceBar = makeBar(41, data.price_color);
							selFinDiv.appendChild(priceBar);

							var liquidityBar = makeBar(71, data.liquidity_color);
							selFinDiv.appendChild(liquidityBar);

							var earthquakeBar = makeBar(101, data.earthquake_color);
							selFinDiv.appendChild(earthquakeBar);

							var deductionBar = makeBar(131, data.deduction_color);
							selFinDiv.appendChild(deductionBar);

							var managementBar = makeBar(161, data.management_color);
							selFinDiv.appendChild(managementBar);

							var lineDiv1 = makeLineDiv(180);
							selFinDiv.appendChild(lineDiv1);

							var lineDiv2 = makeLineDiv(360);
							selFinDiv.appendChild(lineDiv2);

							var lineDiv3 = makeLineDiv(540);
							selFinDiv.appendChild(lineDiv3);

							var lineDiv4 = makeLineDiv(720);
							selFinDiv.appendChild(lineDiv4);

							var lineDiv5 = makeLineDiv(900);
							selFinDiv.appendChild(lineDiv5);

							setTimeout(function() { showLabel(priceBar, data.price_score, liquidityBar, data.liquidity_score, earthquakeBar, data.earthquake_score, deductionBar, data.deduction_score, managementBar, data.management_score); }, 10);

							var resultUrl = "https://" + fqdn + "/inspection/result?key=" + encodeURIComponent(data.key);

							var inspectionButton = document.createElement("a");
							inspectionButton.setAttribute("href", resultUrl);
							inspectionButton.setAttribute("target", "_blank");
							inspectionButton.style.position = "absolute";
							inspectionButton.style.top = "200px";
							inspectionButton.style.left = "27px";
							inspectionButton.style.display = "block";
							inspectionButton.style.width = "400px";
							inspectionButton.style.height = "30px";
							inspectionButton.style.border = "1px solid #000000";
							inspectionButton.style.textAlign = "center";
							inspectionButton.style.backgroundColor = "#cccccc";
							inspectionButton.style.color = "#000000";
							inspectionButton.style.textDecoration = "none";
							inspectionButton.style.fontWeight = "bold";
							inspectionButton.style.lineHeight = "30px";
							inspectionButton.style.fontSize = "20px";
							inspectionButton.innerHTML = "診断結果を見る";

							selFinDiv.appendChild(inspectionButton);

							var closeButton = document.createElement("a");
							closeButton.setAttribute("href", "javascript:void(0);");
							closeButton.style.position = "absolute";
							closeButton.style.top = "200px";
							closeButton.style.left = "483px";
							closeButton.style.display = "block";
							closeButton.style.width = "400px";
							closeButton.style.height = "30px";
							closeButton.style.border = "1px solid #000000";
							closeButton.style.textAlign = "center";
							closeButton.style.backgroundColor = "#cccccc";
							closeButton.style.color = "#000000";
							closeButton.style.textDecoration = "none";
							closeButton.style.fontWeight = "bold";
							closeButton.style.lineHeight = "30px";
							closeButton.style.fontSize = "20px";
							closeButton.innerHTML = "閉じる";

							closeButton.addEventListener("click", function() { changeSelFinStatus(selFinHeight, 0); return false; }, false);

							selFinDiv.appendChild(closeButton);
						}

						document.body.appendChild(selFinOuterDiv);
					});
				});
			}
		});
	}

	function changeSelFinStatus(offsetHeight, mode) {
		var body = document.body;

		body.style.position = "relative";

		if (mode == 1) {
			body.style.top = String(offsetHeight) + "px";
		}
		else {
			body.style.top = "0px";
		}

		var children = body.children;

		for (var i = 0; i < children.length; i ++) {
			var child = children[i];
			var style = child.currentStyle || document.defaultView.getComputedStyle(child, '');

			if (style.position == "fixed") {
				var top = style.top;

				if (top.match(/^\d+px/)) {
					var topInt = parseInt(top.replace(/px/, ""));

					if (mode == 1) {
						topInt += offsetHeight;
					}
					else {
						topInt -= offsetHeight;
					}

					child.style.top = String(topInt) + "px";
				}
			}
		}
	}

	function showLabel(priceBar, priceScore, liquidityBar, liquidityScore, earthquakeBar, earthquakeScore, deductionBar, deductionScore, managementBar, managementScore) {
		if (labelOffset < 100) {
			labelOffset ++;

			if (priceScore >= labelOffset) {
				var currentWidth = parseInt(720 / 100 * labelOffset);
				priceBar.style.width = String(currentWidth) + "px";
			}

			if (liquidityScore >= labelOffset) {
				var currentWidth = parseInt(720 / 100 * labelOffset);
				liquidityBar.style.width = String(currentWidth) + "px";
			}

			if (earthquakeScore >= labelOffset) {
				var currentWidth = parseInt(720 / 100 * labelOffset);
				earthquakeBar.style.width = String(currentWidth) + "px";
			}

			if (deductionScore >= labelOffset) {
				var currentWidth = parseInt(720 / 100 * labelOffset);
				deductionBar.style.width = String(currentWidth) + "px";
			}

			if (managementScore >= labelOffset) {
				var currentWidth = parseInt(720 / 100 * labelOffset);
				managementBar.style.width = String(currentWidth) + "px";
			}

			setTimeout(function() { showLabel(priceBar, priceScore, liquidityBar, liquidityScore, earthquakeBar, earthquakeScore, deductionBar, deductionScore, managementBar, managementScore) }, 10);
		}
	}

	function makeLabelDiv(left, title) {
		var labelDiv = document.createElement("div");
		labelDiv.style.position = "absolute";
		labelDiv.style.top = "20px";
		labelDiv.style.left = String(left) + "px";
		labelDiv.style.width = "20px";
		labelDiv.style.height = "10px";
		labelDiv.style.fontSize = "8px";
		labelDiv.style.textAlign = "center";
		labelDiv.innerHTML = title;

		return labelDiv;
	}

	function makeTitleLabelDiv(top, title) {
		var titleLabelDiv = document.createElement("div");
		titleLabelDiv.style.position = "absolute";
		titleLabelDiv.style.top = String(top) + "px";
		titleLabelDiv.style.left = "0px";
		titleLabelDiv.style.width = "100px";
		titleLabelDiv.style.fontSize = "14px;"
		titleLabelDiv.style.fontWeight = "bold";
		titleLabelDiv.style.lineHeight = "20px";
		titleLabelDiv.style.textAlign = "center";
		titleLabelDiv.innerHTML = title;

		return titleLabelDiv;
	}

	function makeScoreDiv(top, score) {
		var scoreDiv = document.createElement("div");
		scoreDiv.style.position = "absolute";
		scoreDiv.style.top = String(top) + "px";
		scoreDiv.style.left = "100px";
		scoreDiv.style.width = "80px";
		scoreDiv.style.fontSize = "16px";
		scoreDiv.style.fontWeight = "bold";
		scoreDiv.style.lineHeight = "20px";
		scoreDiv.style.textAlign = "center";
		scoreDiv.style.borderTop = "1px solid #ffffff";
		scoreDiv.style.borderBottom = "1px solid #ffffff";
		scoreDiv.style.borderLeft = "1px solid #ffffff";
		scoreDiv.innerHTML = String(score);

		return scoreDiv;
	}

	function makeBar(top, backgroundColor) {
		var bar = document.createElement("div");
		bar.style.position = "absolute";
		bar.style.top = String(top) + "px";
		bar.style.left = "181px";
		bar.style.width = "0px;"
		bar.style.height = "20px";
		bar.style.backgroundColor = backgroundColor;

		return bar;
	}

	function makeLineDiv(left) {
		var lineDiv = document.createElement("div");
		lineDiv.style.position = "absolute";
		lineDiv.style.top = "35px";
		lineDiv.style.left = String(left) + "px";
		lineDiv.style.width = "1px";
		lineDiv.style.height = "155px";
		lineDiv.style.backgroundColor = "#ffffff";

		return lineDiv;
	}
});